# -*- coding: utf-8 -*-
# Generated by Django 1.11 on 2018-02-26 00:20
from __future__ import unicode_literals

from django.db import migrations, models
import jsonfield.fields


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ('group_app', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='PeriodicPay',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=64, verbose_name='Periodic pay name')),
                ('when_add', models.DateTimeField(auto_now_add=True, verbose_name='When pay created')),
                ('calc_type',
                 models.CharField(choices=[('df', 'Default periodic pay'), ('cs', 'Custom periodic pay')], default='df',
                                  max_length=2, verbose_name='Script type for calculations')),
                ('amount', models.FloatField(verbose_name='Total amount')),
                ('extra_info', jsonfield.fields.JSONField()),
            ],
            options={
                'verbose_name': 'Periodic pay',
                'verbose_name_plural': 'Periodic pays',
                'db_table': 'periodic_pay',
                'ordering': ['-id'],
                'permissions': (('can_view_periodic_pay', 'Can view periodic pay'),),
            },
        ),
        migrations.CreateModel(
            name='Tariff',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=32, verbose_name='Service title')),
                ('descr', models.CharField(max_length=256, verbose_name='Service description')),
                ('speedIn', models.FloatField(default=0.0, verbose_name='Speed In')),
                ('speedOut', models.FloatField(default=0.0, verbose_name='Speed Out')),
                ('amount', models.FloatField(default=0.0, verbose_name='Price')),
                ('calc_type', models.CharField(
                    choices=[('Df', 'Base calculate functionality'), ('Dp', 'IS'), ('Cp', 'Private service')],
                    default='Df', max_length=2, verbose_name='Script')),
                ('is_admin', models.BooleanField(default=False, verbose_name='Tech service')),
                ('groups', models.ManyToManyField(blank=True, to='group_app.Group')),
            ],
            options={
                'verbose_name': 'Service',
                'verbose_name_plural': 'Services',
                'db_table': 'tariffs',
                'ordering': ['title'],
            },
        ),
    ]
