# Generated by Django 2.0 on 2019-07-01 10:50

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('group_app', '0003_auto_20180808_1236'),
    ]

    operations = [
        migrations.CreateModel(
            name='PotentialSubscriber',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('fio', models.CharField(max_length=256, verbose_name='fio')),
                ('telephone', models.CharField(blank=True, max_length=16, null=True, validators=[django.core.validators.RegexValidator('^(\\+[7,8,9,3]\\d{10,11})?$')], verbose_name='Telephone')),
                ('town', models.CharField(blank=True, help_text='Town, if group does not already exist', max_length=127, null=True, verbose_name='Town')),
                ('street', models.CharField(blank=True, max_length=127, null=True, verbose_name='Street')),
                ('house', models.CharField(blank=True, max_length=12, null=True, verbose_name='House')),
                ('description', models.TextField(blank=True, null=True, verbose_name='Comment')),
                ('make_data', models.DateTimeField(auto_now_add=True, verbose_name='Create date')),
                ('deadline', models.DateField(blank=True, help_text='Date when connection must be finished', null=True, verbose_name='Deadline connection')),
                ('group', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='group_app.Group', verbose_name='User group')),
            ],
            options={
                'verbose_name': 'Potential customer',
                'verbose_name_plural': 'Potential customers',
                'db_table': 'new_customers',
                'ordering': ('-id',),
            },
        ),
    ]
