# -*- coding: utf-8 -*-
# Generated by Django 1.11 on 2018-02-26 00:20
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Conversation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=32)),
                ('date_create', models.DateTimeField(auto_now_add=True)),
                ('author', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Conversation',
                'verbose_name_plural': 'Conversations',
                'db_table': 'conversations',
                'permissions': (('can_view_conversation', 'Can view conversation'),),
            },
        ),
        migrations.CreateModel(
            name='ConversationMembership',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status', models.CharField(
                    choices=[('adm', 'Admin'), ('gst', 'Guest'), ('ban', 'Banned user'), ('inv', 'Inviter')],
                    default='gst', max_length=3)),
                ('account', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='memberships',
                                              to=settings.AUTH_USER_MODEL)),
                ('conversation',
                 models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='msg_app.Conversation')),
                ('who_invite_that_user',
                 models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE,
                                   related_name='self_conversations', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Conversation membership',
                'verbose_name_plural': 'Conversation memberships',
                'db_table': 'conversation_memberships',
            },
        ),
        migrations.CreateModel(
            name='Message',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('text', models.TextField(verbose_name='Body')),
                ('sent_at', models.DateTimeField(auto_now_add=True, verbose_name='sent at')),
                ('attachment', models.FileField(blank=True, null=True, upload_to='messages_attachments/%Y_%m_%d')),
            ],
            options={
                'verbose_name': 'Message',
                'verbose_name_plural': 'Messages',
                'db_table': 'messages',
                'ordering': ['-sent_at'],
                'permissions': (('can_view_messages', 'Can view messages'),),
            },
        ),
        migrations.CreateModel(
            name='MessageStatus',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('state', models.CharField(choices=[('new', 'New'), ('old', 'Seen'), ('del', 'Deleted')], default='new',
                                           max_length=3)),
                ('msg', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='msg_statuses',
                                          to='msg_app.Message')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='usr_msg_status',
                                           to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Message status',
                'verbose_name_plural': 'Messages statuses',
                'db_table': 'message_status',
            },
        ),
        migrations.AddField(
            model_name='message',
            name='account_status',
            field=models.ManyToManyField(through='msg_app.MessageStatus', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='message',
            name='author',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='messages',
                                    to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='message',
            name='conversation',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='msg_app.Conversation',
                                    verbose_name='Conversation'),
        ),
        migrations.AddField(
            model_name='conversation',
            name='participants',
            field=models.ManyToManyField(related_name='conversations', through='msg_app.ConversationMembership',
                                         to=settings.AUTH_USER_MODEL),
        ),
        migrations.AlterUniqueTogether(
            name='messagestatus',
            unique_together={('msg', 'user', 'state')},
        ),
    ]
