# Generated by Django 2.1.3 on 2019-02-07 12:31

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Messenger',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=64, verbose_name='Title')),
                ('bot_type', models.PositiveSmallIntegerField(blank=True, choices=[(1, 'Viber')], verbose_name='Bot type')),
                ('slug', models.SlugField(verbose_name='Slug')),
            ],
            options={
                'verbose_name': 'messenger',
                'verbose_name_plural': 'Messengers',
                'db_table': 'messengers',
                'ordering': ('title',),
            },
        ),
        migrations.CreateModel(
            name='ViberMessage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('msg', models.TextField(verbose_name='Message')),
                ('date', models.DateTimeField(auto_now_add=True, verbose_name='Date')),
                ('sender', models.CharField(max_length=32, verbose_name='Sender')),
            ],
            options={
                'verbose_name': 'Viber message',
                'verbose_name_plural': 'Viber messages',
                'db_table': 'viber_messages_notifications',
                'ordering': ('-date',),
            },
        ),
        migrations.CreateModel(
            name='ViberSubscriber',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uid', models.CharField(max_length=32, verbose_name='User unique id in viber')),
                ('name', models.CharField(blank=True, max_length=32, null=True, verbose_name='Name')),
                ('avatar', models.URLField(blank=True, max_length=250, null=True, verbose_name='Avatar')),
                ('account', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='System account')),
            ],
            options={
                'verbose_name': 'Viber subscriber',
                'verbose_name_plural': 'Viber subscribers',
                'db_table': 'viber_subscriber',
                'ordering': ('name',),
            },
        ),
        migrations.CreateModel(
            name='ViberMessenger',
            fields=[
                ('messenger_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='messenger.Messenger')),
                ('token', models.CharField(max_length=64, verbose_name='Bot secret token')),
                ('avatar', models.ImageField(null=True, upload_to='viber_avatar', verbose_name='Avatar')),
            ],
            options={
                'verbose_name': 'Viber messenger',
                'verbose_name_plural': 'Viber messengers',
                'db_table': 'viber_messenger_notifications',
                'ordering': ('title',),
            },
            bases=('messenger.messenger',),
        ),
        migrations.AddField(
            model_name='vibermessage',
            name='subscriber',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='messenger.ViberSubscriber', verbose_name='Subscriber'),
        ),
        migrations.AddField(
            model_name='vibermessage',
            name='messenger',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='messenger.ViberMessenger', verbose_name='messenger'),
        ),
    ]
