# Generated by Django 2.1.1 on 2019-03-05 12:47

from django.db import migrations, models
import ip_pool.fields


class Migration(migrations.Migration):

    replaces = [('ip_pool', '0001_initial'), ('ip_pool', '0002_change_unique'), ('ip_pool', '0003_auto_20181019_1230'), ('ip_pool', '0004_auto_20190305_1243')]

    initial = True

    dependencies = [
        ('group_app', '0002_group_code'),
    ]

    operations = [
        migrations.CreateModel(
            name='NetworkModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('network', ip_pool.fields.GenericIpAddressWithPrefix(help_text='Ip address of network. For example: 192.168.1.0 or fde8:6789:1234:1::', unique=True, verbose_name='IP network')),
                ('kind', models.CharField(choices=[('inet', 'Internet'), ('guest', 'Guest'), ('trust', 'Trusted'), ('device', 'Devices'), ('admin', 'Admin')], default='guest', max_length=6, verbose_name='Kind of network')),
                ('description', models.CharField(max_length=64, verbose_name='Description')),
                ('ip_start', models.GenericIPAddressField(verbose_name='Start work ip range')),
                ('ip_end', models.GenericIPAddressField(verbose_name='End work ip range')),
                ('groups', models.ManyToManyField(to='group_app.Group', verbose_name='Groups')),
            ],
            options={
                'verbose_name': 'Network',
                'verbose_name_plural': 'Networks',
                'db_table': 'ip_pool_network',
                'ordering': ('network',),
            },
        )
    ]
