# Generated by Django 2.1 on 2018-11-23 15:56

from django.db import migrations, models
import django.db.models.deletion
import encrypted_model_fields.fields

PAY_GW_ID = 0


def make_default_pay_gw(apps, _):
    global PAY_GW_ID
    PayAllTimeGateway = apps.get_model('finapp.PayAllTimeGateway')
    pay_gw = PayAllTimeGateway.objects.first()
    if pay_gw is None:
        pay_gw = PayAllTimeGateway.objects.create(
            title='default',
            secret='secret',
            service_id='service_id',
            slug='default'
        )
    PAY_GW_ID = pay_gw.pk


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('abonapp', '0001_squashed_0008_auto_20181115_1206'),
    ]

    operations = [
        migrations.RunSQL(migrations.RunSQL.noop, state_operations=[
            migrations.CreateModel(
                name='AllTimePayLog',
                fields=[
                    ('pay_id', models.CharField(max_length=36, primary_key=True, serialize=False, unique=True)),
                    ('date_add', models.DateTimeField(auto_now_add=True)),
                    ('summ', models.FloatField(verbose_name='Cost', default=0.0)),
                    ('trade_point', models.CharField(blank=True, default=None, max_length=20, null=True, verbose_name='Trade point')),
                    ('receipt_num', models.BigIntegerField(default=0, verbose_name='Receipt number')),
                    ('abon', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.SET_DEFAULT, to='abonapp.Abon')),
                ],
                options={
                    'db_table': 'all_time_pay_log',
                    'ordering': ('-date_add',),
                },
            )
        ]),
        migrations.CreateModel(
            name='PayAllTimeGateway',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=64, verbose_name='Title')),
                ('secret', encrypted_model_fields.fields.EncryptedCharField(verbose_name='Secret')),
                ('service_id', models.CharField(max_length=64, verbose_name='Service id')),
                ('slug', models.SlugField(max_length=32, unique=True, verbose_name='Slug')),
            ],
            options={
                'verbose_name': 'All time gateway',
                'db_table': 'pay_all_time_gateways',
                'ordering': ('title',),
            },
        ),
        migrations.RunPython(make_default_pay_gw),
        migrations.AddField(
            model_name='alltimepaylog',
            name='pay_gw',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='finapp.PayAllTimeGateway', verbose_name='Pay gateway', default=lambda: PAY_GW_ID),
        ),
    ]
