## Сервисы
&mdash; это скрипты которые, зачастую, оформлены в юниты systemd.
Сейчас есть такие сервисы:
* [dhcp_lever](#dhcp_lever)
* [monitoring_agent](#monitoring_agent)
* [periodic](#periodic)


### dhcp_lever
Этот скрипт не очень похож на сервис, т.к. выполняется при каждом запросе от DHCP сервера.
Работа DHCP организована так:
- Запрос приходит от абонента с опцией-82, далее с помощью dhcp-relay направляется на dhcp сервер где
и находится этот скрипт
- ISC-DHCP-server выполняет этот скрипт, передавая параметры в таком порядке: действие, ip адрес для
абонента, мак адрес абонента, мак адрес свича через которые получен запрос, порт свича с которого пришёл запрос.
- Биллинг оповещается через *http get* запрос о событии в dhcp сервере
- По мак адресу свича и его порту ищется абонент.
- Если он найден то проверяется установлен-ли флаг "Динамические настройки по dhcp" в блоке "Устройство"
на странице абонента.
- Если флаг динамических настроек есть то проверяется совпадает ли новый ip с dhcp сервера с тем что есть у
абонента, и если он совпадает то ничего не происходит. В противном случае обновляем информацию об абоненте на
сервере доступа к сети (NAS - Network Access Server).

Беспокоится о том что не будет обновлена другая информация не нужно, об этом позаботится [periodic](#periodic).
А если вам нужно немедленно обновить абонента без ожидания то просто нажмите на кнопку *Сохранить* на странице абонента.

P.S. *dhcp_lever* это python сценарий, который импортирует *urllib* для отправки http запроса, при большой частоте
запросов из dhcp это может начать чувствоваться, потому есть его аналог написанный на C++, ледит он на github:
[github.com/nerosketch/dhcp_lever.git](https://github.com/nerosketch/dhcp_lever.git). Клонируйте репозиторий, соберите
с помощью *Make* и получите исполняемый файл *dhcp_lever* с такой же логикой, но значительно шустрее.

### monitoring_agent
Это тоже не совсем сервис, как и [dhcp_lever](#dhcp_lever) он связывает систему мониторинга с биллингом. Сейчас работает
с Nagios, но изменить его для любой другой системы мониторинга совсем не сложно, достаточно подправить параметры
приходящиие от этой системы. Располагать скрипт следует, обычно, на той же машине где выполняется мониторинг, чтоб он мог
запускать скрипт при возникновении событий.

Каждый раз когда в сети происходит событие, *Nagios* дёргает этот скрипт и даёт знать биллингу какое устройство
не в сети или появилось после сбоя. Дальше биллинг на основе этого посылает оповещения ответственным за участок в
котором находится оборудование и выставляет статусы в списке устройств.

**Настройка** &mdash; Для работы этому скрипту так же надо передать секретное слово биллинга *API_AUTH_SECRET*,
указывается в *settings.py*, так что тоже рекомендую ограничить права на чтение. Кроме этого надо указать адрес web
сервера биллинга, откройте содержимое *agent/monitoring_agent.py* и всё поймёте.


### periodic
Периодически запускается чтоб проверить совпадает-ли информация в биллинге с тем что находится в NAS.
Завершает закончившие действовать услуги, проводит периодические платежи.
Просто укажите в cron или *systemd.timer* этот скрипт на периодичность, например, в пол часа, или по ночам,
как вам удобнее. Кстати, готовый юнит *Systemd* есть в папке *systemd_units* и называется *djing.timer* и *djing.service*
соответственно. Так же скопируйте их в */etc/systemd/system*, перечитайте юниты с помощью *systemctl daemon-reload* и
запустите таймер, примерно так:
```bash
# cp /var/www/djing/systemd_units/djing.timer /etc/systemd/system
# systemctl daemon-reload
# systemctl enable djing.timer
# systemctl start djing.timer*
```
Каждую ночь в 2 часа скрипт будет обслуживать вашу систему. Можете выставить вашу частоту отредактировав *djing.timer*.
