### Сбор информации трафика по netflow

Установите flow-tools, мы будем использовать его в качестве коллектора.

Затем надо собрать утилиту для преобразования flow в запрос для mysql.
Если не хотите собирать то есть собранный бинарь в папке */var/www/djing/agent/netflow/djing_flow.tar.gz*.
Распакуйте его или соберите из github:
```
cd /var/www/djing/agent/netflow/
git clone https://github.com/nerosketch/djing_flow.git djing_flow_git
cd djing_flow_git/
make
mv djing_flow ../
cd ..
rm -rf djing_flow_git
```
У себя заметил такую особенность, биллиотека flow-tools для C собирается и линкуется в Fedora, но отказывается
линковаться в Debian/Ubuntu.

Инструкцию по использованию можно найти на странице [djing_flow](https://github.com/nerosketch/djing_flow).
Посмотреть пример работы можно с помощью файла дампа трафика flow-tools. Соберём такой дамп с помощью **flow-capture**.
> \# flow-capture -p /run/flow.pid -w /tmp/djing_flow -n1 -N0 0/0/1234

Запустится сбор трафика. Чтоб узнать больше почитайте инструкции по использованию flow-tools. Настройте netflow sensor
на ваш сервер. Для того чтоб сбросить дамп трафика на диск отправте сигнал **-HUP** процессу flow-capture.
В */tmp/djing_flow* вы найдёте этот самый файл дампа трафика. И тут уже можно посмотреть как работает утилита
**djing_flow**:
> \$ ./djing_flow < /tmp/*.tmp

На выходе вы получите запрос для mysql. Можно перенаправить его по конвееру в mysql.

Принцип действия сбора состоит в том что сенсоры нааправляются на биллинг, а там его ждёт коллектор flow-capture,
Если сенсоров несколько то и процессов flow-capture будет несколько на разных портах. Все они складывают свой дамп
в */tmp/djing_flow*, по сигналу **HUP** для процесса flow-capture закрывается файл дампа, обрабатывается скриптом,
указанным в праметре *R* flow-capture и собирается новый дамп. Всё это вы можете почитать в документации к flow-tools.

Systemd юнит _djing_rotate.timer_ и _djing_rotate.service_ каждую минуту запускают скрипт *netflow_collect.sh*, а он
уже отправляет сигнал *HUP* всем запущенным процессам flow-capture, переносит файлы в */tmp/djing_flow/dump* и потом
конкатинирует с помощью flow-cat и по конвееру передаёт *djing_flow*, который и конвертирует фамп в запрос для mysql.

Почему была написана своя утилита а не использован экспорт из поставки flow-tools? Первое это формат хранения в бд,
второе это сжатие всех потоков за минуту по каждому ip адресу в одну строку(использовано бинарное дерево поиска для ip).
То есть для одного ip адреса за минуту суммируются все сессии, и складывается трафик и количество пакетов, таким образом
в БД кладётся одна запись в минуту вместо десятка для одного абонента. Если вы знаете способ сделать это стандартыми
средствами flow-tools буду очень рад если вы и [мне](mailto:nerosketch@gmail.com) скажите :)

P.S. Рекомендую смонтировать папку /tmp в tmpfs чтобы не дёргать часто винт, т.к. файлообмен там будет активный.
