# Generated by Django 2.1.1 on 2019-03-05 19:32

from django.db import migrations, models
import django.db.models.deletion
import djing.fields
import jsonfield.fields


class Migration(migrations.Migration):
    replaces = [
        ('devapp', '0001_initial'),
        ('devapp', '0002_auto_20180409_1318'),
        ('devapp', '0003_auto_20180529_1311'),
        ('devapp', '0004_device_extra_data'),
        ('devapp', '0005_device_ip_address_change')
    ]

    initial = True

    dependencies = [
        ('group_app', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Device',
            fields=[
                ('id', models.AutoField(
                    auto_created=True, primary_key=True,
                    serialize=False, verbose_name='ID'
                )),
                ('ip_address', models.GenericIPAddressField(
                    blank=True, null=True, verbose_name='Ip address'
                )),
                ('mac_addr', djing.fields.MACAddressField(
                    blank=True, integer=True,
                    null=True, unique=True,
                    verbose_name='Mac address'
                )),
                ('comment', models.CharField(
                    max_length=256, verbose_name='Comment'
                )),
                ('devtype', models.CharField(
                    choices=[('Dl', 'DLink switch'), ('Pn', 'PON OLT'),
                             ('On', 'PON ONU BDCOM'), ('Ex', 'Eltex switch'),
                             ('Zt', 'OLT ZTE C320'), ('Zo', 'Zte ONU F660'),
                             ('Z6', 'Zte ONU F601'), ('Hw', 'Huawei switch')],
                    default='Dl', max_length=2,
                    verbose_name='Device type'
                )),
                ('man_passw', models.CharField(
                    blank=True, max_length=16,
                    null=True, verbose_name='SNMP password'
                )),
                ('status', models.CharField(
                    choices=[('und', 'Undefined'), ('up', 'Up'),
                             ('unr', 'Unreachable'), ('dwn', 'Down')],
                    default='und', max_length=3,
                    verbose_name='Status'
                )),
                ('is_noticeable', models.BooleanField(
                    default=False,
                    verbose_name='Send notify when monitoring state changed'
                )),
                ('group', models.ForeignKey(
                    blank=True, null=True,
                    on_delete=django.db.models.deletion.SET_NULL,
                    to='group_app.Group', verbose_name='Device group'
                )),
                ('parent_dev', models.ForeignKey(
                    blank=True, null=True,
                    on_delete=django.db.models.deletion.SET_NULL,
                    to='devapp.Device', verbose_name='Parent device'
                )),
                ('extra_data', jsonfield.fields.JSONField(
                    blank=True,
                    help_text='Extra data in JSON format. You may use it for your custom data',
                    null=True, verbose_name='Extra data'
                )),
                ('snmp_extra', models.CharField(
                    blank=True, max_length=256,
                    null=True, verbose_name='SNMP extra info'
                ))
            ],
            options={
                'verbose_name': 'Device',
                'verbose_name_plural': 'Devices',
                'db_table': 'dev',
                'ordering': ('id',),
            },
        ),
        migrations.CreateModel(
            name='Port',
            fields=[
                ('id', models.AutoField(
                    auto_created=True, primary_key=True,
                    serialize=False, verbose_name='ID'
                )),
                ('num', models.PositiveSmallIntegerField(
                    default=0, verbose_name='Number'
                )),
                ('descr', models.CharField(
                    blank=True, max_length=60, null=True,
                    verbose_name='Description'
                )),
                ('device', models.ForeignKey(
                    on_delete=django.db.models.deletion.CASCADE,
                    to='devapp.Device', verbose_name='Device'
                )),
            ],
            options={
                'verbose_name': 'Port',
                'verbose_name_plural': 'Ports',
                'db_table': 'dev_port',
                'permissions': (('can_toggle_ports', 'Can toggle ports'),),
                'ordering': ('num',),
                'unique_together': {('device', 'num')},
            },
        ),
    ]
