# -*- coding: utf-8 -*-
# Generated by Django 1.11 on 2018-04-25 12:03
from __future__ import unicode_literals

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    replaces = [('accounts_app', '0001_initial'), ('accounts_app', '0002_auto_20180413_1839'), ('accounts_app', '0003_auto_20180425_1135')]

    initial = True

    dependencies = [
        ('group_app', '0001_initial'),
        ('auth', '0008_alter_user_username_max_length'),
    ]

    operations = [
        migrations.CreateModel(
            name='BaseAccount',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('password', models.CharField(max_length=128, verbose_name='password')),
                ('last_login', models.DateTimeField(blank=True, null=True, verbose_name='last login')),
                ('is_superuser', models.BooleanField(default=False, help_text='Designates that this user has all permissions without explicitly assigning them.', verbose_name='superuser status')),
                ('username', models.CharField(max_length=127, unique=True, verbose_name='profile username')),
                ('fio', models.CharField(max_length=256, verbose_name='fio')),
                ('birth_day', models.DateField(auto_now_add=True, verbose_name='birth day')),
                ('is_active', models.BooleanField(default=True, verbose_name='Is active')),
                ('is_admin', models.BooleanField(default=False)),
                ('telephone', models.CharField(max_length=16, validators=[django.core.validators.RegexValidator('^\\+[7,8,9,3]\\d{10,11}$')], verbose_name='Telephone')),
            ],
            options={
                'db_table': 'base_accounts',
            },
        ),
        migrations.CreateModel(
            name='UserProfile',
            fields=[
                ('baseaccount_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='accounts_app.BaseAccount')),
                ('email', models.EmailField(default='admin@example.ru', max_length=254)),
                ('avatar', models.ImageField(default=None, null=True, upload_to='user/avatar', verbose_name='Avatar')),
                ('responsibility_groups', models.ManyToManyField(blank=True, to='group_app.Group', verbose_name='Responsibility groups')),
            ],
            options={
                'verbose_name': 'Staff account profile',
                'verbose_name_plural': 'Staff account profiles',
                'ordering': ['fio'],
                'permissions': (('can_view_userprofile', 'Can view staff profile'),),
            },
            bases=('accounts_app.baseaccount',),
        ),
        migrations.AddField(
            model_name='baseaccount',
            name='groups',
            field=models.ManyToManyField(blank=True, help_text='The groups this user belongs to. A user will get all permissions granted to each of their groups.', related_name='user_set', related_query_name='user', to='auth.Group', verbose_name='groups'),
        ),
        migrations.AddField(
            model_name='baseaccount',
            name='user_permissions',
            field=models.ManyToManyField(blank=True, help_text='Specific permissions for this user.', related_name='user_set', related_query_name='user', to='auth.Permission', verbose_name='user permissions'),
        ),
        migrations.AlterField(
            model_name='baseaccount',
            name='username',
            field=models.CharField(max_length=127, unique=True, validators=[django.core.validators.RegexValidator('^\\w{1,127}$')], verbose_name='profile username'),
        ),
        migrations.AlterField(
            model_name='baseaccount',
            name='telephone',
            field=models.CharField(blank=True, max_length=16, validators=[django.core.validators.RegexValidator('^(\\+[7,8,9,3]\\d{10,11})?$')], verbose_name='Telephone'),
        ),
    ]
