# Generated by Django 2.1.1 on 2019-03-05 20:00

import bitfield.models
import django.core.validators
import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    replaces = [('abonapp', '0001_initial'), ('abonapp', '0002_auto_20180808_1448'), ('abonapp', '0003_abon_nas'),
                ('abonapp', '0004_auto_20180918_1734'), ('abonapp', '0005_current_tariff'),
                ('abonapp', '0006_change_ip'), ('abonapp', '0007_auto_20181101_1545'),
                ('abonapp', '0008_auto_20181115_1206')]

    initial = True

    dependencies = [
        ('tariff_app', '0003_auto_20181115_1206'),
        ('gw_app', '0001_initial'),
        ('tariff_app', '0001_initial'),
        ('ip_pool', '0001_initial'),
        ('gw_app', '0002_auto_20181101_1545'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('group_app', '0001_initial'),
        ('accounts_app', '0001_initial'),
        ('devapp', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='AbonTariff',
            fields=[
                ('id', models.AutoField(
                    auto_created=True, primary_key=True,
                    serialize=False, verbose_name='ID'
                )),
                ('tariff', models.ForeignKey(
                    on_delete=django.db.models.deletion.CASCADE,
                    related_name='linkto_tariff',
                    to='tariff_app.Tariff'
                )),
                ('time_start', models.DateTimeField(
                    blank=True, default=None, null=True
                )),
                ('deadline', models.DateTimeField(
                    blank=True, default=None, null=True
                )),
            ],
            options={
                'ordering': ('time_start',),
                'permissions': (('can_complete_service', 'finish service perm'),),
                'verbose_name': 'Abon service',
                'verbose_name_plural': 'Abon services',
                'db_table': 'abonent_tariff'
            },
        ),
        migrations.CreateModel(
            name='AbonStreet',
            fields=[
                ('id', models.AutoField(
                    auto_created=True, primary_key=True,
                    serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=64)),
                ('group', models.ForeignKey(
                    on_delete=django.db.models.deletion.CASCADE,
                    to='group_app.Group'
                )),
            ],
            options={
                'verbose_name': 'Street',
                'verbose_name_plural': 'Streets',
                'db_table': 'abon_street',
                'ordering': ('name',),
            },
        ),
        migrations.CreateModel(
            name='Abon',
            fields=[
                ('baseaccount_ptr', models.OneToOneField(
                    auto_created=True, on_delete=django.db.models.deletion.CASCADE,
                    parent_link=True, primary_key=True, serialize=False,
                    to='accounts_app.BaseAccount'
                )),
                ('current_tariff', models.OneToOneField(
                    blank=True, default=None, null=True,
                    on_delete=django.db.models.deletion.SET_NULL,
                    to='abonapp.AbonTariff'
                )),
                ('group', models.ForeignKey(
                    blank=True, null=True,
                    on_delete=django.db.models.deletion.SET_NULL,
                    to='group_app.Group', verbose_name='User group'
                )),
                ('ballance', models.FloatField(default=0.0)),
                ('ip_address', models.GenericIPAddressField(
                    blank=True, null=True,
                    verbose_name='Ip address'
                )),
                ('description', models.TextField(
                    blank=True, null=True, verbose_name='Comment'
                )),
                ('street', models.ForeignKey(
                    blank=True, null=True,
                    on_delete=django.db.models.deletion.SET_NULL,
                    to='abonapp.AbonStreet', verbose_name='Street'
                )),
                ('house', models.CharField(
                    blank=True, max_length=12,
                    null=True, verbose_name='House'
                )),
                ('device', models.ForeignKey(
                    blank=True, null=True,
                    on_delete=django.db.models.deletion.SET_NULL,
                    to='devapp.Device'
                )),
                ('dev_port', models.ForeignKey(
                    blank=True, null=True,
                    on_delete=django.db.models.deletion.SET_NULL,
                    to='devapp.Port'
                )),
                ('is_dynamic_ip', models.BooleanField(
                    default=False, verbose_name='Is dynamic ip'
                )),
                ('nas', models.ForeignKey(
                    blank=True, default=None, null=True,
                    on_delete=django.db.models.deletion.SET_NULL,
                    to='gw_app.NASModel', verbose_name='Network access server'
                )),
                ('autoconnect_service', models.BooleanField(
                    default=False, verbose_name='Automatically connect next service'
                )),
                ('last_connected_tariff', models.ForeignKey(
                    blank=True, default=None, null=True,
                    on_delete=django.db.models.deletion.SET_NULL,
                    to='tariff_app.Tariff',
                    verbose_name='Last connected service'
                )),
                ('markers', bitfield.models.BitField(
                    (('icon_donkey', 'Donkey'), ('icon_fire', 'Fire'),
                     ('icon_ok', 'Ok'), ('icon_king', 'King'),
                     ('icon_tv', 'TV'), ('icon_smile', 'Smile'),
                     ('icon_dollar', 'Dollar'), ('icon_service', 'Service'),
                     ('icon_mrk', 'Marker')), default=0
                )),
            ],
            options={
                'ordering': ('fio',),
                'permissions': (
                    ('can_buy_tariff', 'Buy service perm'),
                    ('can_add_ballance', 'fill account'),
                    ('can_ping', 'Can ping')),
                'verbose_name': 'Abon',
                'verbose_name_plural': 'Abons',
                'db_table': 'abonent',
                'unique_together': {('ip_address', 'nas')}
            },
            bases=('accounts_app.baseaccount',),
        ),
        migrations.CreateModel(
            name='AbonLog',
            fields=[
                ('id', models.AutoField(
                    auto_created=True, primary_key=True,
                    serialize=False, verbose_name='ID'
                )),
                ('abon', models.ForeignKey(
                    on_delete=django.db.models.deletion.CASCADE,
                    to='abonapp.Abon')),
                ('amount', models.FloatField(default=0.0)),
                ('author', models.ForeignKey(
                    blank=True, null=True,
                    on_delete=django.db.models.deletion.SET_NULL,
                    related_name='+', to=settings.AUTH_USER_MODEL
                )),
                ('comment', models.CharField(max_length=128)),
                ('date', models.DateTimeField(auto_now_add=True)),
            ],
            options={
                'db_table': 'abonent_log',
                'ordering': ('-date',)
            },
        ),
        migrations.CreateModel(
            name='AdditionalTelephone',
            fields=[
                ('abon', models.ForeignKey(
                    on_delete=django.db.models.deletion.CASCADE,
                    related_name='additional_telephones',
                    to='abonapp.Abon'
                )),
                ('id', models.AutoField(
                    auto_created=True, primary_key=True,
                    serialize=False, verbose_name='ID'
                )),
                ('telephone', models.CharField(
                    max_length=16, validators=[
                        django.core.validators.RegexValidator('^(\\+[7,8,9,3]\\d{10,11})?$')
                    ],
                    verbose_name='Telephone')
                 ),
                ('owner_name', models.CharField(max_length=127)),
            ],
            options={
                'verbose_name': 'Additional telephone',
                'verbose_name_plural': 'Additional telephones',
                'db_table': 'additional_telephones',
                'ordering': ('owner_name',),
            },
        ),
        migrations.CreateModel(
            name='AllPayLog',
            fields=[
                ('pay_id', models.CharField(max_length=64, primary_key=True, serialize=False)),
                ('date_action', models.DateTimeField(auto_now_add=True)),
                ('summ', models.FloatField(default=0.0)),
                ('pay_system_name', models.CharField(max_length=16)),
            ],
            options={
                'db_table': 'all_pay_log',
                'ordering': ('-date_action',),
            },
        ),
        migrations.CreateModel(
            name='AllTimePayLog',
            fields=[
                ('abon',
                 models.ForeignKey(
                     blank=True, default=None, null=True,
                     on_delete=django.db.models.deletion.SET_DEFAULT,
                     to='abonapp.Abon'
                 )),
                ('pay_id', models.CharField(
                    max_length=36, primary_key=True,
                    serialize=False, unique=True
                )),
                ('date_add', models.DateTimeField(auto_now_add=True)),
                ('summ', models.FloatField(default=0.0)),
                ('trade_point', models.CharField(
                    blank=True, default=None, max_length=20,
                    null=True, verbose_name='Trade point'
                )),
                ('receipt_num', models.BigIntegerField(default=0, verbose_name='Receipt number')),
            ],
            options={
                'db_table': 'all_time_pay_log',
                'ordering': ('-date_add',),
            },
        ),
        migrations.CreateModel(
            name='InvoiceForPayment',
            fields=[
                ('id', models.AutoField(
                    auto_created=True, primary_key=True,
                    serialize=False, verbose_name='ID'
                )),
                ('abon', models.ForeignKey(
                    on_delete=django.db.models.deletion.CASCADE,
                    to='abonapp.Abon'
                )),
                ('status', models.BooleanField(default=False)),
                ('amount', models.FloatField(default=0.0)),
                ('comment', models.CharField(max_length=128)),
                ('date_create', models.DateTimeField(auto_now_add=True)),
                ('date_pay', models.DateTimeField(blank=True, null=True)),
                ('author', models.ForeignKey(
                    blank=True, null=True,
                    on_delete=django.db.models.deletion.SET_NULL,
                    related_name='+', to=settings.AUTH_USER_MODEL
                ))
            ],
            options={
                'verbose_name': 'Debt',
                'verbose_name_plural': 'Debts',
                'db_table': 'abonent_inv_pay',
                'ordering': ('date_create',)
            },
        ),
        migrations.CreateModel(
            name='PassportInfo',
            fields=[
                ('id', models.AutoField(
                    auto_created=True, primary_key=True,
                    serialize=False, verbose_name='ID'
                )),
                ('series', models.CharField(
                    max_length=4, validators=[django.core.validators.integer_validator],
                    verbose_name='Pasport serial'
                )),
                ('number', models.CharField(
                    max_length=6, validators=[django.core.validators.integer_validator],
                    verbose_name='Pasport number'
                )),
                ('distributor', models.CharField(
                    max_length=64, verbose_name='Distributor'
                )),
                ('date_of_acceptance', models.DateField(
                    verbose_name='Date of acceptance'
                )),
                ('abon', models.OneToOneField(
                    blank=True, null=True,
                    on_delete=django.db.models.deletion.CASCADE,
                    to='abonapp.Abon'
                ))
            ],
            options={
                'ordering': ('series',),
                'verbose_name': 'Passport Info',
                'verbose_name_plural': 'Passport Info',
                'db_table': 'passport_info'
            },
        ),
        migrations.CreateModel(
            name='PeriodicPayForId',
            fields=[
                ('id', models.AutoField(
                    auto_created=True, primary_key=True,
                    serialize=False, verbose_name='ID'
                )),
                ('periodic_pay', models.ForeignKey(
                    on_delete=django.db.models.deletion.CASCADE,
                    to='tariff_app.PeriodicPay',
                    verbose_name='Periodic pay'
                )),
                ('last_pay', models.DateTimeField(
                    blank=True, null=True, verbose_name='Last pay time'
                )),
                ('next_pay', models.DateTimeField(
                    verbose_name='Next time to pay'
                )),
                ('account', models.ForeignKey(
                    on_delete=django.db.models.deletion.CASCADE,
                    to='abonapp.Abon',
                    verbose_name='Account'
                ))
            ],
            options={
                'db_table': 'periodic_pay_for_id',
                'ordering': ('last_pay',)
            },
        ),
        migrations.CreateModel(
            name='AbonRawPassword',
            fields=[
                ('account', models.OneToOneField(
                    on_delete=django.db.models.deletion.CASCADE,
                    primary_key=True, serialize=False,
                    to='abonapp.Abon'
                )),
                ('passw_text', models.CharField(max_length=64)),
            ],
            options={
                'db_table': 'abon_raw_password',
            },
        ),
    ]
