/*
 * Decompiled with CFR 0.152.
 */
package irc.gui.sbox;

import irc.ListenerGroup;
import irc.gui.sbox.SboxConfiguration;
import irc.gui.sbox.SboxPanel;
import irc.gui.sbox.SboxScrollBar;
import irc.gui.sbox.SboxScrollBarListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class SboxVerticalScrollBar
extends SboxPanel
implements SboxScrollBar,
MouseListener,
MouseMotionListener,
Runnable {
    private double _min;
    private double _max;
    private double _val;
    private boolean _mouseDown = false;
    private boolean _mouseDownUp;
    private boolean _mouseDownDown;
    private int _base;
    private final int _arrow = 10;
    private double _view;
    private MouseEvent _repeatEvent;
    private int _repeatEventCount;
    private Thread _repeatThread;
    private ListenerGroup _listeners;

    public SboxVerticalScrollBar(SboxConfiguration sboxConfiguration, int n, int n2, double d) {
        super(sboxConfiguration);
        this._view = d;
        this._listeners = new ListenerGroup();
        this.setMinimum(n);
        this.setMaximum(n2);
        this.setValue(n);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void run() {
        boolean bl = false;
        this._repeatEventCount = 0;
        while (!bl) {
            try {
                if (this._repeatEventCount++ == 0) {
                    Thread.sleep(500L);
                } else {
                    Thread.sleep(50L);
                }
                this.mousePressed(this._repeatEvent);
            }
            catch (InterruptedException interruptedException) {
                bl = true;
            }
        }
    }

    public void release() {
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        super.release();
    }

    public void addSboxScrollBarListener(SboxScrollBarListener sboxScrollBarListener) {
        this._listeners.addListener((Object)sboxScrollBarListener);
    }

    public void removeSboxScrollBarListener(SboxScrollBarListener sboxScrollBarListener) {
        this._listeners.removeListener((Object)sboxScrollBarListener);
    }

    private Color[] getColors(boolean bl) {
        Color[] colorArray = new Color[5];
        if (!bl) {
            colorArray[0] = this.getColor(5);
            colorArray[1] = this.getColor(0);
            colorArray[2] = this.getColor(3);
            colorArray[3] = this.getColor(4);
            colorArray[4] = this.getColor(1);
        } else {
            colorArray[0] = this.getColor(7);
            colorArray[1] = this.getColor(0);
            colorArray[2] = this.getColor(3);
            colorArray[3] = this.getColor(4);
            colorArray[4] = this.getColor(1);
        }
        return colorArray;
    }

    private void drawA(Graphics graphics, int n, boolean bl) {
        int n2 = this.getSize().width;
        int n3 = n;
        Color[] colorArray = this.getColors(bl);
        graphics.setColor(colorArray[0]);
        for (int i = 0; i < n2 - 5; ++i) {
            graphics.drawLine(i + 3, n3 - 1, i + 3, n3 - 1 - i);
        }
        graphics.setColor(colorArray[1]);
        graphics.drawLine(0, n3 - 1, n2 - 2, n3 - n2 + 1);
        graphics.setColor(colorArray[2]);
        graphics.drawLine(1, n3 - 1, n2 - 2, n3 - n2 + 2);
        graphics.setColor(colorArray[4]);
        graphics.drawLine(2, n3 - 1, n2 - 2, n3 - n2 + 3);
        graphics.setColor(colorArray[1]);
        graphics.drawLine(n2 - 1, n3 - 1, n2 - 1, n3 - n2);
        graphics.setColor(colorArray[4]);
        graphics.drawLine(n2 - 2, n3 - 1, n2 - 2, n3 + 3 - n2);
    }

    private void drawB(Graphics graphics, int n, boolean bl) {
        int n2 = this.getSize().width;
        int n3 = n;
        Color[] colorArray = this.getColors(bl);
        graphics.setColor(colorArray[0]);
        for (int i = 0; i < n2 - 5; ++i) {
            graphics.drawLine(n2 - 1 - i - 3, n3, n2 - 1 - i - 3, n3 + i);
        }
        graphics.setColor(colorArray[1]);
        graphics.drawLine(0, n3 + n2 - 1, n2 - 1, n3);
        graphics.setColor(colorArray[2]);
        graphics.drawLine(1, n3 + n2 - 3, n2 - 2, n3);
        graphics.setColor(colorArray[4]);
        graphics.drawLine(1, n3 + n2 - 4, n2 - 3, n3);
        graphics.setColor(colorArray[3]);
        graphics.drawLine(0, n3, 0, n3 + n2 - 2);
        graphics.setColor(colorArray[4]);
        graphics.drawLine(1, n3, 1, n3 + n2 - 4);
    }

    private void drawInside(Graphics graphics, int n, int n2, boolean bl) {
        int n3 = this.getSize().width;
        Color[] colorArray = this.getColors(bl);
        int n4 = n;
        graphics.setColor(colorArray[3]);
        graphics.drawLine(0, n4, 0, n4 + n2 - 1);
        graphics.setColor(colorArray[4]);
        graphics.drawLine(1, n4, 1, n4 + n2 - 1);
        graphics.drawLine(n3 - 2, n4, n3 - 2, n4 + n2 - 1);
        graphics.setColor(colorArray[1]);
        graphics.drawLine(n3 - 1, n4, n3 - 1, n4 + n2 - 1);
        graphics.setColor(colorArray[0]);
        graphics.fillRect(2, n4, n3 - 4, n2);
    }

    public Dimension getPreferredSize() {
        return new Dimension(16, 100);
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    private int getMargin() {
        return 10 + this.getSize().width;
    }

    private int getCursorLong() {
        int n = this.getSize().height;
        int n2 = this.getMargin();
        if (this._min == this._max) {
            return n - 2 * n2;
        }
        double d = (double)(n - 2 * n2) * this._view;
        int n3 = (int)(d / (this._max - this._min + 1.0) * (double)(n - 2 * n2));
        if (n3 > (n - 2 * n2) / 3) {
            n3 = (n - 2 * n2) / 3;
        }
        return n3;
    }

    private int getPos() {
        int n;
        int n2 = n = this.getSize().height;
        int n3 = this.getMargin();
        int n4 = this.getCursorLong();
        return (int)((this._val * (double)(n2 - n3 - n4) + (this._max - this._val) * (double)n3) / this._max - (double)n3);
    }

    public void update(Graphics graphics) {
        Graphics graphics2;
        Image image;
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        int n3 = this.getMargin();
        int n4 = this.getCursorLong();
        try {
            image = this.createImage(n, n2);
            graphics2 = image.getGraphics();
        }
        catch (Throwable throwable) {
            return;
        }
        graphics2.setColor(this.getColor(6));
        graphics2.fillRect(0, 0, n, n2);
        this.drawInside(graphics2, 2, 8, this._mouseDownUp);
        this.drawB(graphics2, n3 - n, this._mouseDownUp);
        Color[] colorArray = this.getColors(this._mouseDownUp);
        graphics2.setColor(colorArray[3]);
        graphics2.drawLine(1, 0, n - 2, 0);
        graphics2.drawLine(0, 0, 0, 1);
        graphics2.setColor(colorArray[4]);
        graphics2.drawLine(1, 1, n - 2, 1);
        graphics2.setColor(colorArray[1]);
        graphics2.drawLine(n - 1, 0, n - 1, 1);
        graphics2.setColor(colorArray[4]);
        graphics2.drawLine(n / 2, 4, n / 4 + 1, 4 + n / 4 - 1);
        graphics2.drawLine(n / 2, 4, 3 * n / 4 - 1, 4 + n / 4 - 1);
        this.drawInside(graphics2, n2 - 10, 8, this._mouseDownDown);
        this.drawA(graphics2, n2 - n3 + n, this._mouseDownDown);
        colorArray = this.getColors(this._mouseDownDown);
        graphics2.setColor(colorArray[3]);
        graphics2.drawLine(0, n2 - 2, 0, n2 - 1);
        graphics2.setColor(colorArray[1]);
        graphics2.drawLine(n - 1, n2 - 2, n - 1, n2 - 1);
        graphics2.drawLine(1, n2 - 1, n - 2, n2 - 1);
        graphics2.setColor(colorArray[4]);
        graphics2.drawLine(1, n2 - 2, n - 2, n2 - 2);
        graphics2.setColor(colorArray[4]);
        graphics2.drawLine(n / 2, n2 - 5, n / 4 + 1, n2 - 5 - n / 4 + 1);
        graphics2.drawLine(n / 2, n2 - 5, 3 * n / 4 - 1, n2 - 5 - n / 4 + 1);
        int n5 = this.getPos() + n3;
        this.drawInside(graphics2, n5, n4, this._mouseDown);
        this.drawA(graphics2, n5, this._mouseDown);
        this.drawB(graphics2, n5 + n4, this._mouseDown);
        graphics.drawImage(image, 0, 0, this);
    }

    public void setMinimum(int n) {
        this._min = n;
        if (this._min > this._max) {
            this._min = this._max;
        }
        if (this._val < this._min) {
            this.updateValue(this._min);
        }
        this.repaint();
    }

    public void setMaximum(int n) {
        this._max = n;
        if (this._max < this._min) {
            this._max = this._min;
        }
        if (this._val > this._max) {
            this.updateValue(this._max);
        }
        this.repaint();
    }

    public void setValue(int n) {
        this._val = n;
        if (this._val < this._min) {
            this._val = this._min;
        }
        if (this._val > this._max) {
            this._val = this._max;
        }
        this.repaint();
    }

    public int getValue() {
        return (int)(this._val + 0.5);
    }

    private boolean inCursor(int n, int n2) {
        int n3 = this.getSize().width;
        int n4 = this.getCursorLong();
        n2 -= this.getMargin();
        return n + (n2 -= this.getPos()) >= -1 && n2 + n - n4 - n3 <= -1;
    }

    private boolean inSubArrow(int n, int n2) {
        return n + (n2 -= this.getMargin()) <= -1;
    }

    private boolean inAddArrow(int n, int n2) {
        int n3 = this.getSize().width;
        int n4 = this.getSize().height;
        return n2 + n - n4 + this.getMargin() - n3 >= -1;
    }

    private double getValue(int n, int n2) {
        int n3;
        int n4 = n3 = this.getSize().height;
        int n5 = this.getMargin();
        int n6 = n2 - n5 - this._base;
        return (this._max - this._min) * (double)n6 / (double)(n4 -= n5 * 2 + this.getCursorLong()) + this._min;
    }

    private void updateValue(double d) {
        int n = this.getValue();
        this._val = d;
        if (this._val < this._min) {
            this._val = this._min;
        }
        if (this._val > this._max) {
            this._val = this._max;
        }
        this.repaint();
        if (this.getValue() != n) {
            this._listeners.sendEventAsync("valueChanged", (Object)this);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private void beginRepeat(MouseEvent mouseEvent) {
        this._repeatEvent = mouseEvent;
        this._repeatThread = new Thread((Runnable)this, "Scrolling thread");
        this._repeatThread.start();
    }

    private void endRepeat() {
        if (this._repeatThread != null) {
            try {
                this._repeatThread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this._repeatThread.join(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._repeatThread = null;
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.inCursor(mouseEvent.getX(), mouseEvent.getY())) {
            this._base = mouseEvent.getY() - this.getMargin() - this.getPos();
            this._mouseDown = true;
            this.repaint();
            return;
        }
        if (this.inSubArrow(mouseEvent.getX(), mouseEvent.getY())) {
            this._mouseDownUp = true;
            this.updateValue(this._val - 1.0);
            this.repaint();
        } else if (this.inAddArrow(mouseEvent.getX(), mouseEvent.getY())) {
            this._mouseDownDown = true;
            this.updateValue(this._val + 1.0);
            this.repaint();
        } else if (this.getValue(mouseEvent.getX(), mouseEvent.getY()) < this._val) {
            this.updateValue(this._val - 10.0);
            this.repaint();
        } else if (this.getValue(mouseEvent.getX(), mouseEvent.getY()) > this._val) {
            this.updateValue(this._val + 10.0);
            this.repaint();
        }
        if (this._repeatThread == null) {
            this.beginRepeat(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.endRepeat();
        this._mouseDown = false;
        this._mouseDownUp = false;
        this._mouseDownDown = false;
        this.repaint();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this._repeatEvent = mouseEvent;
        if (this._mouseDown) {
            this.updateValue(this.getValue(mouseEvent.getX(), mouseEvent.getY()));
        }
    }
}

