/*
 * Decompiled with CFR 0.152.
 */
package irc.gui.sbox;

import irc.FileTextProvider;
import irc.IRCConfiguration;
import irc.ParameterProvider;
import irc.StringParser;
import irc.TextProvider;
import irc.gui.sbox.SboxColorModel;
import irc.gui.sbox.SboxConfiguration;
import java.awt.Color;
import java.util.Locale;
import java.util.Vector;

public class SboxConfigurationLoader {
    private IRCConfiguration _config;
    private ParameterProvider _provider;

    public SboxConfigurationLoader(IRCConfiguration iRCConfiguration) {
        this._config = iRCConfiguration;
        this._provider = this._config.getInterfaceParameterProvider();
    }

    public SboxConfiguration loadSboxConfiguration() throws Exception {
        return this.getSboxConfiguration();
    }

    private String getParameter(String string) {
        return this._provider.getParameter(string);
    }

    private boolean getBoolean(String string, boolean bl) {
        String string2 = this.getParameter(string);
        if (string2 == null) {
            return bl;
        }
        return (string2 = string2.toLowerCase(Locale.ENGLISH).trim()).equals("true") || string2.equals("on") || string2.equals("1");
    }

    private String getString(String string, String string2) {
        String string3 = this.getParameter(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    private int getInt(String string, int n) {
        String string2 = this.getParameter(string);
        if (string2 == null) {
            return n;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            return n;
        }
    }

    private TextProvider getTextProvider() {
        String string = this.getString("language", "sbox-english");
        String string2 = this.getString("languageencoding", "");
        String string3 = this.getString("lngextension", "lng");
        String string4 = this.getString("backuplanguage", "sbox-english");
        String string5 = this.getString("backuplanguageencoding", "");
        return new FileTextProvider(string + "." + string3, string2, string4 + "." + string3, string5, this._config.getFileHandler());
    }

    private String[] getArray(String string) {
        String string2;
        Vector<String> vector = new Vector<String>();
        int n = 1;
        do {
            if ((string2 = this.getParameter(string + n)) != null) {
                vector.insertElementAt(string2, vector.size());
            }
            ++n;
        } while (string2 != null);
        String[] stringArray = new String[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            stringArray[n] = (String)vector.elementAt(n);
        }
        return stringArray;
    }

    private void readDocking(SboxConfiguration sboxConfiguration) {
        StringParser stringParser = new StringParser();
        String[] stringArray = this.getArray("dockingconfig");
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String[] stringArray2 = stringParser.parseString(string);
            if (stringArray2.length < 3) continue;
            String string2 = stringArray2[0].toLowerCase(Locale.ENGLISH);
            String string3 = stringArray2[1].toLowerCase(Locale.ENGLISH);
            String string4 = stringArray2[2].toLowerCase(Locale.ENGLISH);
            boolean bl = false;
            if (string4.equals("undock")) {
                bl = true;
            }
            sboxConfiguration.setDockingPolicy(string2, string3, bl);
        }
    }

    private void readMouse(SboxConfiguration sboxConfiguration, String string, int n, int n2) throws Exception {
        String string2 = this.getString("mouse" + string.toLowerCase(Locale.ENGLISH), n + " " + n2);
        int n3 = string2.indexOf(32);
        if (n3 < 0) {
            throw new Exception("mouse" + string.toLowerCase(Locale.ENGLISH) + " parameter syntax error");
        }
        String string3 = string2.substring(0, n3).trim();
        String string4 = string2.substring(n3 + 1).trim();
        sboxConfiguration.setMouseConfiguration(string, new Integer(string3), new Integer(string4));
    }

    private String[] getHighLightWords() {
        String string = this.getParameter("highlightwords");
        if (string == null) {
            return new String[0];
        }
        return new StringParser().parseString(string);
    }

    private void add(Vector vector, Object object) {
        vector.insertElementAt(object, vector.size());
    }

    private void str2(Vector vector, SboxConfiguration sboxConfiguration, int n, String string) {
        this.add(vector, new String[]{sboxConfiguration.getText(n), string});
    }

    public void loadDefaultPopup(SboxConfiguration sboxConfiguration) {
        boolean bl;
        Vector vector = sboxConfiguration.getNickMenuVector();
        boolean bl2 = bl = sboxConfiguration.getB("showstatus") && !sboxConfiguration.getIRCConfiguration().getB("useinfo");
        if (bl) {
            this.str2(vector, sboxConfiguration, 34561, "/whois %1");
        }
        this.str2(vector, sboxConfiguration, 34562, "/query %1");
        this.str2(vector, sboxConfiguration, 34563, "/kick %2 %1");
        this.str2(vector, sboxConfiguration, 34564, "/mode %2 +b %1");
        String[] stringArray = new String[]{sboxConfiguration.getText(34565), "/mode %2 -o %1", "/mode %2 +b %1", "/kick %2 %1"};
        this.add(vector, stringArray);
        this.add(vector, new String[]{"--"});
        this.str2(vector, sboxConfiguration, 34566, "/mode %2 +o %1");
        this.str2(vector, sboxConfiguration, 34567, "/mode %2 -o %1");
        this.str2(vector, sboxConfiguration, 34568, "/mode %2 +v %1");
        this.str2(vector, sboxConfiguration, 34569, "/mode %2 -v %1");
        if (bl) {
            this.add(vector, new String[]{"--"});
            this.str2(vector, sboxConfiguration, 34570, "/ctcp ping %1");
            this.str2(vector, sboxConfiguration, 34571, "/ctcp version %1");
            this.str2(vector, sboxConfiguration, 34572, "/ctcp time %1");
            this.str2(vector, sboxConfiguration, 34573, "/ctcp finger %1");
        }
    }

    private void readPopup(SboxConfiguration sboxConfiguration) {
        if (!this.getBoolean("configurepopup", false)) {
            this.loadDefaultPopup(sboxConfiguration);
            return;
        }
        Vector vector = sboxConfiguration.getNickMenuVector();
        String[] stringArray = this.getArray("popupmenustring");
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = this.getArray("popupmenucommand" + (i + 1) + "_");
            String[] stringArray3 = new String[1 + stringArray2.length];
            stringArray3[0] = stringArray[i];
            for (int j = 0; j < stringArray2.length; ++j) {
                stringArray3[j + 1] = stringArray2[j];
            }
            this.add(vector, stringArray3);
        }
    }

    private SboxColorModel getColorModel() {
        SboxColorModel sboxColorModel = new SboxColorModel();
        for (int i = 0; i < sboxColorModel.getColorCount(); ++i) {
            String string = this.getParameter("color" + i);
            try {
                if (string == null) continue;
                sboxColorModel.setColor(i, new Color(Integer.parseInt(string, 16)));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sboxColorModel;
    }

    private SboxConfiguration getSboxConfiguration() throws Exception {
        SboxConfiguration sboxConfiguration = new SboxConfiguration(this._config);
        sboxConfiguration.setTextProvider(this.getTextProvider());
        Vector<String> vector = new Vector<String>();
        String[] stringArray = this.getHighLightWords();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.insertElementAt(stringArray[i], vector.size());
        }
        sboxConfiguration.setHighLightConfig(this.getInt("highlightcolor", 5), this.getBoolean("highlightnick", false), vector);
        sboxConfiguration.set("highlight", this.getBoolean("highlight", false));
        sboxConfiguration.set("timestamp", this.getBoolean("timestamp", false));
        sboxConfiguration.set("showclose", this.getBoolean("showclose", true));
        sboxConfiguration.set("showconnect", this.getBoolean("showconnect", true));
        sboxConfiguration.set("showchanlist", this.getBoolean("showchanlist", true));
        sboxConfiguration.set("showabout", this.getBoolean("showabout", true));
        sboxConfiguration.set("showhelp", this.getBoolean("showhelp", true));
        sboxConfiguration.set("nicklistwidth", this.getInt("nicklistwidth", 130));
        sboxConfiguration.set("shownicklist", this.getBoolean("shownicklist", true));
        sboxConfiguration.set("showmenubar", this.getBoolean("showmenubar", true));
        sboxConfiguration.set("showtaskbar", this.getBoolean("showtaskbar", true));
        sboxConfiguration.set("taskbarside", this.getInt("taskbarside", 0));
        sboxConfiguration.set("nickfield", this.getBoolean("nickfield", false));
        sboxConfiguration.set("nickfieldbg", this.getInt("nickfieldbg", 1));
        sboxConfiguration.set("nickfieldfg", this.getInt("nickfieldfg", 0));
        sboxConfiguration.set("showstatus", this.getBoolean("showstatus", true));
        sboxConfiguration.set("styleselector", this.getBoolean("styleselector", false));
        sboxConfiguration.set("setfontonstyle", this.getBoolean("setfontonstyle", false));
        sboxConfiguration.set("helppage", this.getString("helppage", "http://www.pjirc.com/help.php"));
        sboxConfiguration.set("showchannelnickchanged", this.getBoolean("showchannelnickchanged", true));
        sboxConfiguration.set("showchannelnickmodeapply", this.getBoolean("showchannelnickmodeapply", true));
        sboxConfiguration.set("showchannelmodeapply", this.getBoolean("showchannelmodeapply", true));
        sboxConfiguration.set("showchanneltopicchanged", this.getBoolean("showchanneltopicchanged", true));
        sboxConfiguration.set("showchannelnickquit", this.getBoolean("showchannelnickquit", true));
        sboxConfiguration.set("showchannelnickkick", this.getBoolean("showchannelnickkick", true));
        sboxConfiguration.set("showchannelnickpart", this.getBoolean("showchannelnickpart", true));
        sboxConfiguration.set("showchannelnickjoin", this.getBoolean("showchannelnickjoin", true));
        sboxConfiguration.set("showdock", this.getBoolean("showdock", true));
        sboxConfiguration.set("prefixops", this.getBoolean("prefixops", false));
        sboxConfiguration.set("prefixbold", this.getBoolean("prefixbold", true));
        sboxConfiguration.set("prefixfg", this.getInt("prefixfg", 4));
        sboxConfiguration.set("prefixbg", this.getInt("prefixbg", 0));
        sboxConfiguration.set("automaticqueries", this.getBoolean("automaticqueries", true));
        sboxConfiguration.set("leftnickalign", this.getBoolean("leftnickalign", false));
        sboxConfiguration.set("taskbaritemwidth", this.getInt("taskbaritemwidth", 100));
        sboxConfiguration.set("scrollspeed", this.getInt("scrollspeed", 0));
        sboxConfiguration.set("leaveonundockedwindowclose", this.getBoolean("leaveonundockedwindowclose", false));
        sboxConfiguration.set("nickprefix", this.getString("nickprefix", "<"));
        sboxConfiguration.set("nickpostfix", this.getString("nickpostfix", "> "));
        sboxConfiguration.set("showchannelyoujoin", this.getBoolean("showchannelyoujoin", false));
        sboxConfiguration.set("displayentertexthere", this.getBoolean("displayentertexthere", false));
        sboxConfiguration.set("ignoreallmouseevents", this.getBoolean("ignoreallmouseevents", false));
        sboxConfiguration.set("hideundockedsources", this.getBoolean("hideundockedsources", false));
        sboxConfiguration.set("displaychannelname", this.getBoolean("displaychannelname", true));
        sboxConfiguration.set("displaychannelmode", this.getBoolean("displaychannelmode", true));
        sboxConfiguration.set("displaychannelcount", this.getBoolean("displaychannelcount", true));
        sboxConfiguration.set("displaychanneltopic", this.getBoolean("displaychanneltopic", true));
        sboxConfiguration.setColorModel(this.getColorModel());
        this.readMouse(sboxConfiguration, "nickquery", 1, 2);
        this.readMouse(sboxConfiguration, "urlopen", 1, 2);
        this.readMouse(sboxConfiguration, "channeljoin", 1, 2);
        this.readMouse(sboxConfiguration, "nickpopup", 3, 1);
        this.readMouse(sboxConfiguration, "taskbarpopup", 3, 1);
        this.readPopup(sboxConfiguration);
        this.readDocking(sboxConfiguration);
        return sboxConfiguration;
    }
}

