/*
 * Decompiled with CFR 0.152.
 */
package irc.gui.sbox;

import irc.AudioConfiguration;
import irc.EventDispatcher;
import irc.IRCConfiguration;
import irc.ListenerGroup;
import irc.Source;
import irc.SourceListener;
import irc.StringParser;
import irc.StyleContext;
import irc.gui.GUISource;
import irc.gui.common.AWTIrcTextField;
import irc.gui.common.MouseWheelPanelListener;
import irc.gui.common.MouseWheelPanelWrapper;
import irc.gui.sbox.AWTStyleSelectorEx;
import irc.gui.sbox.AWTStyleSelectorExListener;
import irc.gui.sbox.BaseAWTSourceListener;
import irc.gui.sbox.SboxConfiguration;
import irc.gui.sbox.SboxScrollBar;
import irc.gui.sbox.SboxScrollBarListener;
import irc.gui.sbox.SboxSeparator;
import irc.gui.sbox.SboxVerticalScrollBar;
import irc.style.FormattedStringDrawer;
import irc.style.StyledList;
import irc.style.StyledListListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Locale;

public class BaseAWTSource
extends Panel
implements GUISource,
SourceListener,
ActionListener,
SboxScrollBarListener,
FocusListener,
StyledListListener,
WindowListener,
MouseWheelPanelListener,
AWTStyleSelectorExListener {
    protected Source _source;
    protected SboxVerticalScrollBar _scroll;
    protected Panel _panel;
    protected StyledList _list;
    protected AWTIrcTextField _textField;
    protected FormattedStringDrawer _styler;
    protected String _title;
    protected String _strippedTitle;
    private ListenerGroup _listeners;
    protected SboxConfiguration _sboxConfiguration;
    protected AWTStyleSelectorEx _selector;
    protected boolean _topToBottom;
    private MouseWheelPanelWrapper _wrapper;
    private String _nickPrefix;
    private String _nickPostfix;

    public BaseAWTSource(SboxConfiguration sboxConfiguration, Source source) {
        this(sboxConfiguration, source, false);
    }

    public BaseAWTSource(SboxConfiguration sboxConfiguration, Source source, boolean bl) {
        this._topToBottom = bl;
        this._sboxConfiguration = sboxConfiguration;
        this._listeners = new ListenerGroup();
        this._source = source;
        this.addFocusListener(this);
        this._source.addSourceListener((SourceListener)this);
        this._panel = new Panel();
        this._panel.addFocusListener(this);
        this._panel.setBackground(Color.white);
        this._scroll = new SboxVerticalScrollBar(this._sboxConfiguration, 0, 0, 0.1);
        this._scroll.addSboxScrollBarListener(this);
        this.setLayout(new BorderLayout());
        IRCConfiguration iRCConfiguration = this._sboxConfiguration.getIRCConfiguration();
        Color color = this._sboxConfiguration.getColor(13);
        Color color2 = this._sboxConfiguration.getColor(14);
        Color color3 = this._sboxConfiguration.getColor(15);
        this._list = new StyledList(iRCConfiguration, true, iRCConfiguration.getStyleContext(source.getType(), source.getName()), color, color2, color3);
        this._list.addFocusListener(this);
        this._list.addStyledListListener((StyledListListener)this);
        this._styler = new FormattedStringDrawer(iRCConfiguration, this.getStyleContext());
        this._textField = new AWTIrcTextField();
        boolean bl2 = this._sboxConfiguration.getB("displayentertexthere");
        if (bl2) {
            this._textField.setEnterTextHere(true, this.getText(34591));
        }
        Color[] colorArray = iRCConfiguration.getStyleColors(this.getStyleContext());
        this._textField.setBackground(colorArray[0]);
        this._textField.setForeground(colorArray[1]);
        this._textField.addFocusListener(this);
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        this._wrapper = new MouseWheelPanelWrapper((Component)this._panel);
        this._wrapper.addMouseWheelPanelListener((MouseWheelPanelListener)this);
        panel.add((Component)this._wrapper, "Center");
        panel.add((Component)new SboxSeparator(2), "West");
        panel.add((Component)new SboxSeparator(3), "East");
        panel.add((Component)new SboxSeparator(0), "North");
        panel.add((Component)new SboxSeparator(1), "South");
        this.add((Component)panel, "Center");
        this._panel.setLayout(new BorderLayout());
        this._panel.add((Component)this._scroll, "East");
        this._selector = new AWTStyleSelectorEx(this._sboxConfiguration);
        this._selector.setStyleContext(this.getStyleContext());
        this._selector.addAWTStyleSelectorExListener(this);
        if (this._sboxConfiguration.getB("styleselector")) {
            panel = new Panel(new BorderLayout());
            panel.add((Component)this._textField, "Center");
            panel.add((Component)this._selector, "East");
            this.add((Component)panel, "South");
        } else {
            this.add((Component)this._textField, "South");
        }
        if (this._topToBottom) {
            this._list.setFirst(0);
        } else {
            this._list.setLast(0);
        }
        this._textField.addActionListener((ActionListener)this);
        this.setTitle(this._source.getName());
        this._panel.add((Component)this._list, "Center");
        this._nickPrefix = this.reformat(this._sboxConfiguration.getS("nickprefix"));
        this._nickPostfix = this.reformat(this._sboxConfiguration.getS("nickpostfix"));
    }

    private String reformat(String string) {
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            int n = string.charAt(i);
            if (n == 92 && i != string.length() - 1) {
                if ((n = string.charAt(++i)) == 107) {
                    n = 3;
                } else if (n == 98) {
                    n = 2;
                } else if (n == 117) {
                    n = 31;
                } else if (n == 114) {
                    n = 22;
                } else if (n == 111) {
                    n = 15;
                } else if (n == 115) {
                    n = 32;
                }
            }
            string2 = string2 + (char)n;
        }
        return string2;
    }

    public void release() {
        this._wrapper.removeMouseWheelPanelListener((MouseWheelPanelListener)this);
        this._source.removeSourceListener((SourceListener)this);
        this._panel.removeFocusListener(this);
        this._scroll.removeSboxScrollBarListener(this);
        this._scroll.release();
        this._list.removeFocusListener(this);
        this._list.removeStyledListListener((StyledListListener)this);
        this._textField.removeFocusListener(this);
        this._selector.removeAWTStyleSelectorExListener(this);
        this._selector.release();
        this._textField.removeActionListener((ActionListener)this);
        this._textField.release();
        this._list.release();
        this.removeAll();
    }

    public void setFrontColor(int n) {
        this._selector.getStyleSelector().setFrontColor(n);
    }

    public void setBackColor(int n) {
        this._selector.getStyleSelector().setBackColor(n);
    }

    public void setBold(boolean bl) {
        this._selector.getStyleSelector().setBold(bl);
    }

    public void setUnderline(boolean bl) {
        this._selector.getStyleSelector().setUnderline(bl);
    }

    public Dimension getPreferredSize() {
        return new Dimension(600, 300);
    }

    public void setFieldText(String string) {
        this._textField.setText(string);
        this._textField.setCaretPosition(string.length());
    }

    public String getFieldText() {
        return this._textField.getText();
    }

    public void validateText() {
        this._textField.validateText();
    }

    public StyleContext getStyleContext() {
        return this._sboxConfiguration.getIRCConfiguration().getStyleContext(this._source.getType(), this._source.getName());
    }

    public String getText(int n) {
        return this._sboxConfiguration.getText(n);
    }

    public String getText(int n, String string) {
        return this._sboxConfiguration.getText(n, string);
    }

    public String getText(int n, String string, String string2) {
        return this._sboxConfiguration.getText(n, string, string2);
    }

    public String getText(int n, String string, String string2, String string3) {
        return this._sboxConfiguration.getText(n, string, string2, string3);
    }

    public void addBaseAWTSourceListener(BaseAWTSourceListener baseAWTSourceListener) {
        this._listeners.addListener((Object)baseAWTSourceListener);
    }

    public void removeBaseAWTSourceListener(BaseAWTSourceListener baseAWTSourceListener) {
        this._listeners.removeListener((Object)baseAWTSourceListener);
    }

    public void setTitle(String string) {
        if (string.equals(this._title)) {
            return;
        }
        this._title = string;
        this._strippedTitle = this._styler.getStripped(string);
        this._listeners.sendEvent("titleChanged", (Object)this);
    }

    public String getStrippedTitle() {
        return this._strippedTitle;
    }

    public String getTitle() {
        return this._title;
    }

    public String getShortTitle() {
        return this._source.getName();
    }

    public Source getSource() {
        return this._source;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        EventDispatcher.dispatchEventAsync((Object)this, (String)"actionPerformedEff", (Object[])new Object[]{actionEvent});
    }

    public void actionPerformedEff(ActionEvent actionEvent) {
        if (this._textField.getText().length() == 0) {
            return;
        }
        String string = "";
        string = this._selector.getPrefix();
        if (!this._textField.getText().startsWith("/")) {
            this._source.sendUserString(string + this._textField.getText());
        } else {
            StringParser stringParser = new StringParser();
            String[] stringArray = stringParser.parseString(StringParser.trim((String)this._textField.getText()));
            if (stringArray.length >= 2 && stringArray[0].toLowerCase(Locale.ENGLISH).equals("/join")) {
                this._source.sendString("/focus Channel " + stringArray[1]);
            }
            this._source.sendUserString(this._textField.getText());
        }
        if (this._textField != null) {
            this._textField.setText("");
        }
    }

    public void fontSelected(Font font) {
        this._list.setFont(font);
    }

    public void clear(Source source) {
        this._list.clear();
        this._scroll.setMaximum(this._list.getLineCount() - 1);
        this._scroll.setValue(this._list.getLast());
        this._listeners.sendEvent("eventOccured", (Object)this);
    }

    protected boolean needHighLight(String string) {
        Object object;
        string = string.toLowerCase(Locale.ENGLISH);
        if (this._sboxConfiguration.highLightNick() && string.indexOf((String)(object = this._source.getServer().getNick().toLowerCase(Locale.ENGLISH))) != -1) {
            return true;
        }
        object = this._sboxConfiguration.getHighLightWords();
        while (object.hasMoreElements()) {
            String string2 = ((String)object.nextElement()).toLowerCase(Locale.ENGLISH);
            if (string.indexOf(string2) == -1) continue;
            return true;
        }
        return false;
    }

    protected void checkSound(String string) {
        string = string.toLowerCase(Locale.ENGLISH);
        AudioConfiguration audioConfiguration = this._sboxConfiguration.getIRCConfiguration().getAudioConfiguration();
        Enumeration enumeration = audioConfiguration.getSoundWords();
        while (enumeration.hasMoreElements()) {
            String string2 = ((String)enumeration.nextElement()).toLowerCase(Locale.ENGLISH);
            if (string.indexOf(string2) == -1) continue;
            audioConfiguration.onWord(string2);
        }
    }

    protected void print(String string, int n, boolean bl, boolean bl2) {
        if (n != 1) {
            string = "\u0003" + n + string;
        }
        if (bl) {
            string = "\u0002" + string;
        }
        if (bl2) {
            string = '\u001f' + string;
        }
        if (this._sboxConfiguration.getB("timestamp")) {
            String string2;
            Calendar calendar = Calendar.getInstance();
            String string3 = "" + calendar.get(11);
            if (string3.length() == 1) {
                string3 = "0" + string3;
            }
            if ((string2 = "" + calendar.get(12)).length() == 1) {
                string2 = "0" + string2;
            }
            string = "[" + string3 + ":" + string2 + "] " + string;
        }
        this._list.addLine(string);
        this._scroll.setMaximum(this._list.getLineCount() - 1);
        this._scroll.setValue(this._list.getLast());
        this._listeners.sendEvent("eventOccured", (Object)this);
    }

    protected void print(String string, int n) {
        this.print(string, n, false, false);
    }

    protected void print(String string) {
        this.print(string, 1, false, false);
    }

    private String formatNick(String string) {
        return this._nickPrefix + string + this._nickPostfix;
    }

    public void messageReceived(String string, String string2, Source source) {
        this.checkSound(string2);
        if (this.needHighLight(string2)) {
            this.print(this.formatNick(string) + string2, this._sboxConfiguration.getI("highlightcolor"));
        } else {
            this.print(this.formatNick(string) + string2);
        }
    }

    public void reportReceived(String string, Source source) {
        this.print(string);
    }

    public void noticeReceived(String string, String string2, Source source) {
        this.print("-" + string + "- " + string2, 5);
    }

    public void action(String string, String string2, Source source) {
        this.print("* " + string + " " + string2, 6);
    }

    public void leave() {
        this._source.leave();
    }

    public void mouseWheelMoved(Integer n) {
        int n2 = n;
        this._scroll.setValue(this._scroll.getValue() + n2);
        if (this._topToBottom) {
            this._list.setFirst(this._scroll.getValue());
        } else {
            this._list.setLast(this._scroll.getValue());
        }
    }

    public void valueChanged(SboxScrollBar sboxScrollBar) {
        if (this._topToBottom) {
            this._list.setFirst(this._scroll.getValue());
        } else {
            this._list.setLast(this._scroll.getValue());
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getComponent() != this._textField) {
            this._textField.requestFocus();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void channelEvent(StyledList styledList, String string, MouseEvent mouseEvent) {
        if (this._sboxConfiguration.matchMouseConfiguration("channeljoin", mouseEvent)) {
            this._source.sendString("/focus Channel " + string);
            this._source.sendString("/join " + string);
        }
    }

    public void URLEvent(StyledList styledList, String string, MouseEvent mouseEvent) {
        if (this._sboxConfiguration.matchMouseConfiguration("urlopen", mouseEvent)) {
            this._source.sendString("/url " + string);
        }
    }

    public void nickEvent(StyledList styledList, String string, MouseEvent mouseEvent) {
        if (this._sboxConfiguration.matchMouseConfiguration("nickquery", mouseEvent)) {
            if (string.equals(this.getSource().getServer().getNick())) {
                return;
            }
            if (this._sboxConfiguration.getB("automaticqueries")) {
                this._source.sendString("/focus Query " + string);
                this._source.sendString("/query " + string);
            }
        }
    }

    public String toString() {
        return "AWTSource : " + this.getStrippedTitle();
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (!bl) {
            this._list.dispose();
        }
    }

    public void copyEvent(StyledList styledList, String string, MouseEvent mouseEvent) {
        Frame frame = new Frame();
        frame.setTitle(this.getText(1819));
        frame.addWindowListener(this);
        frame.setLayout(new GridLayout(1, 1));
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 1));
        frame.add(panel);
        TextArea textArea = new TextArea();
        textArea.setFont(new Font("", 0, 12));
        textArea.setText(string);
        panel.add(textArea);
        ((Component)frame).setSize(400, 300);
        frame.show();
    }

    public void virtualSizeChanged(StyledList styledList) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        windowEvent.getWindow().hide();
        windowEvent.getWindow().dispose();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

